USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_GetProjectRewardPointsByUser]    Script Date: 8/27/2013 2:30:24 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<Dave Hartless>
-- Create date: <08/17/2013>
-- Description:	<This sproc will get the entire list of points generated per project for a user ID>
-- =============================================
CREATE PROCEDURE [dbo].[RP_GetProjectRewardPointsByUser] 
	@userID int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

   select a.DateCreated, b.projectid, c.name, b.points
	from RewardTransaction as a
	left join [dbo].[RewardTransactionBreakdown] as b on a.id = b.RewardTransactionID
	left join [dbo].[RewardLegacyProject] as c on b.ProjectID = c.ID
	where userid = @userID and DailyBudgetID is not null and a.DateCreated >= (GETUTCDATE() - 365)
	
	and points IS NOT NULL --temp fix to keep dev going on web until Points Generation jobs are running each day

	order by datecreated, b.ProjectID
END

GO


